import matplotlib.pyplot as plt
import seaborn as sns
import os
from sklearn.preprocessing import LabelEncoder
from sklearn.model_selection import train_test_split
from sklearn.metrics import classification_report, confusion_matrix
from sklearn.linear_model import LogisticRegression
from sklearn.metrics import accuracy_score
from sklearn.preprocessing import StandardScaler
from sklearn.cluster import KMeans
from sklearn.metrics import silhouette_score
import numpy as np
from scipy import stats
import sys
sys.path.append(sys.argv[1])

import pandas as pd   
import pickle

# Read the fastfood data
fastfood = pd.read_csv(os.path.join(sys.argv[1], 'fastfood.csv'))

# Define the thresholds
max_calories = 500
max_total_fat = 20
max_sodium = 800
max_sugar = 15
min_protein = 10
 
# Create healthy and unhealthy dataframes
healthy_items = fastfood[(fastfood['calories'] <= max_calories) &
                         (fastfood['total_fat'] <= max_total_fat) &
                         (fastfood['sodium'] <= max_sodium) &
                         (fastfood['sugar'] <= max_sugar) &
                         (fastfood['protein'] >= min_protein)] 
 
unhealthy_items = fastfood[~fastfood.index.isin(healthy_items.index)]

print(unhealthy_items)
# pickle.dump(unhealthy_items,open("./ref_result/unhealthy_items.pkl","wb"))


 
import pandas as pd   
import pickle
   
# Assuming the dataset is loaded as a DataFrame named 'fastfood'   
   
# Recommended Daily Intake (RDI) values   
rdi_protein = 50   
rdi_fiber = 25   
rdi_vit_a = 5000   
rdi_vit_c = 60   
rdi_calcium = 1000   
rdi_sat_fat = 20   
rdi_trans_fat = 2   
rdi_sugar = 50   
rdi_sodium = 2400   
rdi_total_carb = 300   
   
# Calculate the percentage of RDI for each nutrient   
fastfood['protein_score'] = (fastfood['protein'] / rdi_protein) * 100   
fastfood['fiber_score'] = (fastfood['fiber'] / rdi_fiber) * 100   
fastfood['vit_a_score'] = (fastfood['vit_a'] / rdi_vit_a) * 100   
fastfood['vit_c_score'] = (fastfood['vit_c'] / rdi_vit_c) * 100   
fastfood['calcium_score'] = (fastfood['calcium'] / rdi_calcium) * 100   
fastfood['sat_fat_score'] = (fastfood['sat_fat'] / rdi_sat_fat) * 100   
fastfood['trans_fat_score'] = (fastfood['trans_fat'] / rdi_trans_fat) * 100   
fastfood['sugar_score'] = (fastfood['sugar'] / rdi_sugar) * 100   
fastfood['sodium_score'] = (fastfood['sodium'] / rdi_sodium) * 100   
fastfood['total_carb_score'] = (fastfood['total_carb'] / rdi_total_carb) * 100   
   
# Calculate the Comprehensive Modified NRF Index   
fastfood['comprehensive_modified_nrf_index'] = (fastfood['protein_score'] + fastfood['fiber_score'] + fastfood['vit_a_score'] + fastfood['vit_c_score'] + fastfood['calcium_score']) - (fastfood['sat_fat_score'] + fastfood['trans_fat_score'] + fastfood['sugar_score'] + fastfood['sodium_score'] + fastfood['total_carb_score']) 

print(fastfood)
# pickle.dump(fastfood,open("./ref_result/fastfood.pkl","wb"))


import pandas as pd   
import pickle
   
# Read the fastfood data
 
vegetarian_keywords = ['chicken', 'beef', 'pork', 'bacon', 'fish', 'shrimp', 'lobster', 'turkey', 'gyro', 'brisket', 'steak', 'ham', 'hot dog', 'corn dog', 'pastrami', 'meatball', 'rib', 'tuna']
vegan_keywords = vegetarian_keywords + ['cheese', 'buttermilk', 'honey', 'ranch', 'cheddar', 'asiago', 'parmesan', 'cream', 'milk', 'dressing', 'mayo', 'mayonnaise', 'butter', 'egg']
gluten_keywords = ['bread', 'bun', 'roll', 'muffin', 'wrap', 'pizza', 'pasta', 'noodle', 'pancake', 'waffle', 'cookie', 'cake', 'pastry', 'sandwich', 'bagel', 'pretzel', 'doughnut']

print(vegetarian_keywords)
# pickle.dump(vegetarian_keywords,open("./ref_result/vegetarian_keywords.pkl","wb"))

print(vegan_keywords)
# pickle.dump(vegan_keywords,open("./ref_result/vegan_keywords.pkl","wb"))

print(gluten_keywords)
# pickle.dump(gluten_keywords,open("./ref_result/gluten_keywords.pkl","wb"))


import pandas as pd   
import pickle

# Read the fastfood data

def is_vegetarian(item):
    return not any(keyword.lower() in item.lower() for keyword in vegetarian_keywords)
 
def is_vegan(item):
    return not any(keyword.lower() in item.lower() for keyword in vegan_keywords)
 
def is_gluten_free(item):
    return not any(keyword.lower() in item.lower() for keyword in gluten_keywords)



import pandas as pd   
import pickle

# Read the fastfood data
  
fastfood['vegetarian'] = fastfood['item'].apply(is_vegetarian)
fastfood['vegan'] = fastfood['item'].apply(is_vegan)
fastfood['gluten_free'] = fastfood['item'].apply(is_gluten_free)

print(fastfood['vegetarian'])
# pickle.dump(fastfood['vegetarian'],open("./ref_result/fastfood['vegetarian'].pkl","wb"))

print(fastfood['vegan'])
# pickle.dump(fastfood['vegan'],open("./ref_result/fastfood['vegan'].pkl","wb"))

print(fastfood['gluten_free'])
# pickle.dump(fastfood['gluten_free'],open("./ref_result/fastfood['gluten_free'].pkl","wb"))



